' ****************************************** AD9834 SIG GEN ******************************************
'   CSE220901 PCB is the Control board.
' An ATMega168/328 controls an ED9854 DDS module.
'
' Step Number values
'
'  6 - Set 1 MHz steps
'  5 - Set 100 KHz steps
'  4 - Set 10 KHz steps
'  3 - Set 1 KHz steps
'  2 - Set 100 Hz steps
'  1 - Set 10 Hz steps
'  0 - Set 1 Hz steps
'
' -------------------------------------------------------------------------------------------------
'
' EEPROM Allocation
'
' 1 - Reserved
' 2-5    Last frequency saved
' 10 Step Number
'

' -------------------------------------------------------------------------------------------------
'
$regfile = "M328def.dat"                                    ' Chip description
$hwstack = 160                                              ' make sure stacks big enough
$swstack = 160
$framesize = 160

$crystal = 8000000

Waitms 50

Config Com1 = 38400 , Synchrone = 0 , Parity = None , Stopbits = 1 , Databits = 8 , Clockpol = 0

' Configure the SPI Bus

'Config Spi = Soft , Dout = Portb.4 , Clock = Portb.5
Spiinit


Ddrb = &B0011_0001                                          ' Port B
Portb = &B0001_1000                                         ' FSYNC starts high

Ddrc = &B011_1100                                           ' Port C direction
Portc = &B100_1110                                          ' Port C pullups

Ddrd = &B1000_0000
Portd = &B0001_1111




' ******************************** LONG ***********************************************************

Dim Frequency As Dword
Dim Mhz As Dword
Dim Khz_high As Dword
Dim Khz_low As Dword
Dim Hz_high As Dword
Dim Hz_low As Dword
Dim Intermediate_1 As Dword
Dim Intermediate_2 As Dword
Dim Mhz_9834 As Dword
Dim Khz_9834 As Dword
Dim Mhz_count As Dword
Dim Khz_count As Dword
Dim Hz_count As Dword
Dim Mhz_factor As Dword
Dim Khz_factor As Dword
Dim Phase As Dword
Dim Phase_save As Dword


' ******************************** WORD ***********************************************************

Dim Kilohertz As Word
Dim Megahertz As Word
Dim Hertz As Word
Dim Khzh As Word
Dim Khzl As Word
Dim Hzh As Word
Dim Hzl As Word
Dim Voltage As Word
Dim Volts As Word
Dim Mv As Word

Dim Control_register As Word
Dim Phase_1 As Word
Dim Phase_2 As Word
Dim 9834_high As Word
Dim 9834_low As Word
Dim 9834_first As Dword
Dim 9834_second As Dword
Dim Step_increment As Dword

' ******************************** BYTE ***********************************************************


Dim Step_counter As Byte                                    ' from 12 position switch
Dim Encoder_value As Byte
Dim 100hz_timer As Byte
Dim Battery_timer As Byte
Dim Previous_step As Byte
Dim Difference As Byte
Dim Correction As Byte

' ********************************* BIT ***********************************************************

Dim Step_bit As Bit
Dim Frequency_up As Bit
Dim Frequency_down As Bit
Dim Memory_flag As Bit
Dim Bat_bit As Bit
Dim Cal_flag As Bit

' ***************************************** ALIASES ***********************************************

Cr Alias &H0D                                               ' carriage return
Lf Alias &H0A                                               ' line feed
Esc Alias &H06
Fq_ud Alias Porta.1

Reset_ad9834 Alias Portb.0                                  ' pulse high to reset AS9834
Fsync Alias Portc.3

Sck Alias Portb.5
Sdata Alias Portb.4

Config Scl = Portc.5                                        ' used i2c pins
Config Sda = Portc.4
I2cinit

$lib "glcdSSD1306-I2C.lib"
Config Graphlcd = Custom , Cols = 128 , Rows = 64 , Lcdname = "SSD1306"
Setfont Font16x16

' Timer 2 Interrupts About 100 Times / Second.

Config Timer2 = Timer , Prescale = 1024
Timer2 = 255 - 78                                           ' gives 100/sec interrupt

Config Int0 = Falling
Config Int1 = Falling
Config Adc = Single , Prescaler = Auto , Reference = Avcc

' *************************************************************************************************


Waitms 100
Cls
Waitms 500

On Int0 Rotary_encoder
On Int1 Step_size
On Timer2 100hz_interrupt
                                            'enable this interrupt

Enable Int0
Enable Int1

Enable Timer0
Enable Timer2
'Enable Interrupts

Splash_screen:
    Lcdat 1 , 1 , " AD9834 " , 2
    Lcdat 3 , 1 , " Sig Gen" , 2
    Lcdat 5 , 1 , " Ver 4.2" , 2
    Lcdat 7 , 1 , "May 2023" , 2

    Wait 2
    Cls
    Lcdat 1 , 1 , "Freq Hz " , 2

  Phase_1 = &HC000
  Phase_2 = &H2000
  ' For AD9834 3579139
   Readeeprom Correction , 10
 '  Correction = 50
   Mhz_factor = 3579100 + Correction                        ' this is for AD9834 with 75 MHz clock
   Khz_factor = Mhz_factor / 10

' ************************ DISPLAY SAVED FREQUENCY *****************************************************
'
' Display initial reads EEPROM and sets registers for frequency stored.

Display_initial:

   Reset_ad9834 = 1
   Waitus 1
   Reset_ad9834 = 0
   Waitus 5
                                                         ' clear screen
' read stored frequency

 '  Readeeprom Mhz , 2                             ' 1 MHz
 '  Readeeprom Khz_high , 3                        ' 10 kHz
 '  Readeeprom Khz_low , 4                         ' 1 kHz
 '  Readeeprom Hz_high , 5                         ' 100 Hz
 '  Readeeprom Hz_low , 6                          ' 1 Hz
 '  Print "Initial F = " ; Mhz ; "," ; Khz_high ; "," ; Khz_low ; ",";
 '  Print Hz_high ; "," ; Hz_low ; Chr(cr);
 '  Frequency = Mhz * 1000000
 '  Intermediate_1 = Khz_high * 10000
 '  Frequency = Frequency + Intermediate_1
 '  Intermediate_1 = Khz_low * 1000
 '  Frequency = Frequency + Intermediate_1
 '  Intermediate_1 = Hz_high * 10
 '  Frequency = Frequency + Intermediate_1
 '  Frequency = Frequency + Hz_low
   Frequency = 10000000


   Gosub Load_9834
   Gosub Show_frequency
   Waitms 50
   Gosub Load_9834
   Gosub Show_frequency
   Step_bit = 0

 ' ************************************************************************************************
'



  ' 100hz_timer = 98                                         ' will not go above 99
 '  Readeeprom Step_counter , 10

   Step_counter = 6
   Gosub Show_step
   Enable Interrupts

' **************************************** MAIN ***************************************************
'
' Looks at various flags and branches accordingly

Main:
   If Frequency_up = 1 Then Gosub Increase_frequency        ' encoder interrupt
   If Frequency_down = 1 Then Gosub Decrease_frequency
 '  If Memory_flag = 1 Then Gosub Save_frequency   ' save current frequency
   If Step_bit = 1 Then Gosub Show_step
   If Bat_bit = 1 Then Gosub Check_battery
   If Cal_flag = 1 Then Gosub Write_calibration
   Goto Main


' -------------------------------------------------------------------------------
' Write Calibration to location 10 in EEPROM

Write_calibration:
   Cal_flag = 0
   Writeeeprom Correction , 10
   Return



' *********************************** SAVE FREQUENCY **********************************************
'
' Saves current frequency in EEPROM to come up on bootup.
' Five locations are used
'
'     EEPROM   Store
'    ----------------
'        2     MHz
'        3     10 KHz
'        4      1 KHz
'        5     10 Hz
'        6      1 Hz

Save_frequency:
   Memory_flag = 0                                          ' reset flag

   Khzh = Kilohertz / 100
   Khzl = Kilohertz Mod 100
   Frequency = Megahertz * 1000000
   Intermediate_1 = Kilohertz * 1000
   Frequency = Frequency + Intermediate_1
   Frequency = Frequency + Hertz
   Print "Frequency = " ; Frequency ; "Hz" ; Chr(cr);
   Megahertz = Frequency / 1000000
   Mhz = Megahertz

   Khz_high = Khzl
   Khz_low = Kilohertz Mod 100
   Hzh = Hertz / 100
   Hzl = Hertz Mod 100
   Writeeeprom Mhz , 2
   Writeeeprom Khzh , 3
   Writeeeprom Khzl , 4
   Writeeeprom Hzh , 5
   Writeeeprom Hzl , 6
   Writeeeprom Step_counter , 10
   Return


' ******************************** ROTARY ENCODER ************************************************
' On INT0
' Rotary Encoder changes frequency

Rotary_encoder:
   Waitms 1
   If Pinb.3 = 1 Then Gosub Normal Else Gosub Reverse
   Return

Normal:
   Encoder_value = Pind And &B0001_0100                     ' bits 2 and 4
   If Encoder_value = &H14 Then Frequency_up = 0
   If Encoder_value = &H14 Then Frequency_down = 1
   If Encoder_value = &H10 Then Frequency_down = 0
   If Encoder_value = &H10 Then Frequency_up = 1
   100hz_timer = 0                                          ' restart timer
   Return

Reverse:
   Encoder_value = Pind And &B0001_0100                     ' bits 2 and 4
   If Encoder_value = &H14 Then Frequency_up = 1
   If Encoder_value = &H14 Then Frequency_down = 0
   If Encoder_value = &H10 Then Frequency_down = 1
   If Encoder_value = &H10 Then Frequency_up = 0
   100hz_timer = 0                                          ' restart timer
   Return


' -------------------------------------------------------------------------------------------------
' On INT1 set step bit

Step_size:
  ' Waitms 20
   If Pinc.1 = 1 Then Step_bit = 1
  ' If Pinc.1 = 1 Then Incr Step_counter
   If Pinc.1 = 0 Then Set Cal_flag
  Waitms 20                                                 ' set flag
   Return





' ---------------------------------------------------------------------------
' Show on 3rd line with ^ what the step size is

Show_step:
   Step_bit = 0

   If Pind.3 = 0 Then Incr Step_counter
'   Incr Step_counter
   If Step_counter > 6 Then Step_counter = 0

   If Step_counter = 0 Then Lcdat 5 , 1 , "Step 1  " , 2
   If Step_counter = 1 Then Lcdat 5 , 1 , "Step 10 " , 2
   If Step_counter = 2 Then Lcdat 5 , 1 , "Step 100" , 2
   If Step_counter = 3 Then Lcdat 5 , 1 , "Step 1k " , 2
   If Step_counter = 4 Then Lcdat 5 , 1 , "Step 10k" , 2
   If Step_counter = 5 Then Lcdat 5 , 1 , "Stp 100k" , 2
   If Step_counter = 6 Then Lcdat 5 , 1 , "Step 1M " , 2
 '  Gosub Modify
   Return

' Modify takes care of anomalous step size

Modify:
   Difference = Step_counter - Previous_step
   If Difference > 1 Then Decr Step_counter
   If Step_counter > 6 Then Step_counter = 0
   Previous_step = Step_counter
   Return


' ********************************** INCREASE FREQUENCY *******************************************
'
' Increase frequency by what is in step counter

Increase_frequency:
   Frequency_up = 0                                         ' reset flag
   If Pinc.1 = 0 Then Incr Correction
   If Pinc.1 = 0 Then Incr Mhz_factor
   If Pinc.1 = 0 Then Lcdat 7 , 1 , Correction ; "    "
   If Pinc.1 = 0 Then Goto If_exit

   Gosub Increment_size
   Frequency = Frequency + Step_increment
   If Frequency > 25000000 Then Frequency = 25000000        ' limit 75 MHz
    Gosub Show_frequency
If_exit:
   Gosub Load_9834
   Return


Increment_size:
   If Step_counter = 0 Then Step_increment = 1
   If Step_counter = 1 Then Step_increment = 10
   If Step_counter = 2 Then Step_increment = 100
   If Step_counter = 3 Then Step_increment = 1000
   If Step_counter = 4 Then Step_increment = 10000
   If Step_counter = 5 Then Step_increment = 100000
   If Step_counter = 6 Then Step_increment = 1000000
   Return


' ********************************** DECREASE FREQUENCY *******************************************
'
' Decrease frequency by what is in step counter

Decrease_frequency:
   Frequency_down = 0                                       ' reset flag
   If Pinc.1 = 0 Then Decr Correction
   If Pinc.1 = 0 Then Decr Mhz_factor
   If Pinc.1 = 0 Then Lcdat 7 , 1 , Correction ; "     "
   If Pinc.1 = 0 Then Goto Df_exit

   Gosub Increment_size
   If Step_increment => Frequency Then Goto Df_exit         ' don't go negative
   Frequency = Frequency - Step_increment
   If Frequency < 10 Then Frequency = 10                    'minimum 10 Hz
   Gosub Show_frequency
Df_exit:
 '  Mhz_factor = Mhz_factor + Correction
   Gosub Load_9834
   Return

' -----------------------------------------------------------------------

Show_frequency:
   If Frequency < 100 Then Goto Less_than_100
   If Frequency < 1000 Then Goto Less_than_1000
   If Frequency < 10000 Then Goto Less_than_10000
   If Frequency < 100000 Then Goto Less_than_100000
   If Frequency < 1000000 Then Goto Less_than_100000
   If Frequency < 10000000 Then Goto Less_than_1000000
   Lcdat 3 , 1 , Frequency , 2
Sf_exit:
   Return

Less_than_100:
    Lcdat 3 , 1 , Frequency ; "     " , 2
    Return

Less_than_1000:
    Lcdat 3 , 1 , Frequency ; "    " , 2
    Return

Less_than_10000:
    Lcdat 3 , 1 , Frequency ; "   " , 2
    Return

Less_than_100000:
   Lcdat 3 , 1 , Frequency ; "  " , 2
    Return

Less_than_1000000:
    Lcdat 3 , 1 , Frequency ; " " , 2
    Return

Less_than_10000000:
    Lcdat 3 , 1 , Frequency ; " " , 2
    Return


' ***************************** AD9834 SETUP ******************************************************
'
' This sets frequency
' The required loads to 9834 are:
' Need to split into 2 16 bit binary words with 01 at start


Load_9834:
   Control_register = &H2000                                ' First word loaded into AD9834
   Mhz_count = Frequency / 1000000                          ' get MHz
   Intermediate_1 = Frequency Mod 1000000                   ' gives remainder
   Khz_count = Intermediate_1 / 1000                        ' get KHz
   Hz_count = Intermediate_1 Mod 1000                       ' get Hz
  ' Mhz_factor = Mhz_factor
   Khz_factor = Mhz_factor / 10
   Phase = Mhz_count * Mhz_factor
   Intermediate_1 = Khz_count * Khz_factor
   Intermediate_1 = Intermediate_1 / 100
   Phase = Phase + Intermediate_1
   Intermediate_2 = Hz_count * Khz_factor
   Intermediate_2 = Intermediate_2 / 100000
   Phase = Phase + Intermediate_2
   Phase = Phase
   Phase_save = Phase

   9834_second = Phase / 16384                              ' gets high 14 bits
   9834_first = Phase Mod 16384                             ' gets low 14 bits
   9834_high = 9834_second
   9834_low = 9834_first
   9834_high = 9834_high Or &B0100_0000_0000_0000           ' add top bits
   9834_low = 9834_low Or &B0100_0000_0000_0000             ' add top bits
   Print "Frequency = " ; Frequency ; "Hz" ; " Phase = " ; Phase ; Chr(cr);

   Fsync = 0                                                ' lower synch bit
   Shiftout Sdata , Sck , Control_register , 0 , 16
   Fsync = 1
   Waitus 1

   Fsync = 0
   Shiftout Sdata , Sck , 9834_low , 0 , 16                 ' LSB
   Fsync = 1
   Waitus 1

   Fsync = 0
   Shiftout Sdata , Sck , 9834_high , 0 , 16                ' MSB
   Fsync = 1
   Waitus 1

   Fsync = 0
   Shiftout Sdata , Sck , Phase_1 , 0 , 16
   Fsync = 1

   Fsync = 0
    Shiftout Sdata , Sck , Phase_2 , 0 , 16
   Fsync = 1
 '  Lcdat 5 , 1 , Hex(9834_high)
  ' Lcdat 7 , 1 , Phase

   Return




' ***************************** 100 HZ INTERRUPT **************************************************

100hz_interrupt:
   Timer2 = 255 - 78
   Incr 100hz_timer
   If 100hz_timer = 30 Then Set Memory_flag
   If 100hz_timer = 100 Then 100hz_timer = 99               ' stay there
   Incr Battery_timer
   If Battery_timer = 200 Then Set Bat_bit                  ' every 2 seconds
   If Battery_timer = 200 Then Battery_timer = 0
   Return

' ****************************************** CHECK BATTERY ****************************************
'
' Read battery voltage on ADC0 and put on bottom line.
' 0-1023 corresponds to 0-5000 mV
' Display as BT=3.1V
'

Check_battery:
   Bat_bit = 0
   If Pinc.1 = 0 Then Goto Cb_exit                          ' reset flag
   Voltage = Getadc(0)
   Voltage = Voltage * 10
   Voltage = Voltage / 218
   Volts = Voltage / 10
   Mv = Voltage Mod 10
   Lcdat 7 , 1 , "Bat=" ; Volts ; "." ; Mv ; "V" , 2
   Print " Battery = " ; Volts ; "." ; Mv ; "V"             ' ; Chr(cr);
Cb_exit:
   Return

$include "font16x16.font"